<?php
require 'vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Alignment;

// معلومات اتصال قاعدة البيانات
$servername = "vsrv681.armadaservers.com";
$username = "mint303_change_stock";
$password = "Plmokn123@";
$dbname = "mint303_change_stock";
$tableName = "alraedh";

// إنشاء اتصال قاعدة البيانات
$conn = new mysqli($servername, $username, $password, $dbname);

// التحقق من الاتصال
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// استرداد البيانات من قاعدة البيانات
$sql = "SELECT * FROM $tableName";
$result = $conn->query($sql);

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// إضافة العناوين للجدول
$sheet->setCellValue('A1', 'اسم');
$sheet->setCellValue('B1', 'العمر');
$sheet->setCellValue('C1', 'المهنة');
$sheet->setCellValue('D1', 'leads_id');

// إضافة البيانات من قاعدة البيانات إلى ملف Excel
$row = 2;
while ($row <= $result->num_rows + 1) {
    $data = $result->fetch_assoc();
    $sheet->setCellValue('A' . $row, $data['Desire']);
    $sheet->setCellValue('B' . $row, $data['Desire']);
    $sheet->setCellValue('C' . $row, $data['Desire']);
    $sheet->setCellValue('D' . $row, $data['leads_id']);

    $row++;
}

// محاذاة البيانات في الجدول
$sheet->getStyle('A1:C1')->getAlignment()->setHorizontal(Alignment::HORIZONTAL_CENTER);

$filename = 'export.xlsx';

try {
    $writer = new Xlsx($spreadsheet);
    $writer->save($filename);
    
    // إرسال الملف للمستخدم
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment; filename="' . basename($filename) . '"');
    header('Expires: 0');
    header('Cache-Control: must-revalidate');
    header('Pragma: public');
    
    $writer->save('php://output');
    exit;
} catch (Exception $e) {
    echo "حدث خطأ أثناء إنشاء الملف: " . $e->getMessage();
}

// إغلاق اتصال قاعدة البيانات
$conn->close();
?>