<?php
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // جلب التواريخ من النموذج
    $startTime = $_POST['startTime'];
    $endTime = $_POST['endTime'];

    // تحديد المعلومات اللازمة
    $email = "mtc9afd-01@makamat.com"; // يمكنك تغييرها بالبريد الإلكتروني الخاص بك
    $password = "mtc9afd-2023"; // يمكنك تغييرها بكلمة مرورك

    // بناء البيانات المرسلة كنص متشفر
    $postData = json_encode(array(
        'email' => $email,
        'password' => $password
    ));

    // بناء الطلب للحصول على رمز التميز
    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => "https://mtc9afd-01.azurewebsites.net/api/Auth/login",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => $postData,
        CURLOPT_HTTPHEADER => array(
            "Content-Type: application/json",
            "cache-control: no-cache"
        ),
        CURLOPT_SSL_VERIFYHOST => false, // تعطيل التحقق من صحة الشهادة
        CURLOPT_SSL_VERIFYPEER => false, // تعطيل التحقق من الشهادة
    ));

    // إرسال الطلب والحصول على الرد
    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);

    if ($err) {
        echo "خطأ في الاتصال بالخادم: " . $err;
    } else {
        // تحويل الرد إلى مصفوفة جسون
        $responseArray = json_decode($response, true);

        if (isset($responseArray['token'])) {
            // استخراج الرمز المميز من الرد
            $token = $responseArray['token'];

            // عرض الرمز المميز
            echo "الرمز المميز: " . $token . "<br>";

            // بناء الطلب الجديد للحصول على بيانات RFID
            $getData = json_encode(array(
                'startTime' => $startTime,
                'endTime' => $endTime
            ));

            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => "https://mtc9afd-01.azurewebsites.net/api/RFIDScanData/timeperiod",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_POSTFIELDS => $getData,
                CURLOPT_HTTPHEADER => array(
                    "Authorization: Bearer $token",
                    "Content-Type: application/json",
                    "cache-control: no-cache"
                ),
                CURLOPT_SSL_VERIFYHOST => false, // تعطيل التحقق من صحة الشهادة
                CURLOPT_SSL_VERIFYPEER => false, // تعطيل التحقق من الشهادة
            ));

            // إرسال الطلب والحصول على الرد
            $response = curl_exec($curl);
            $err = curl_error($curl);
            curl_close($curl);

            if ($err) {
                echo "خطأ في الاتصال بالخادم: " . $err;
            } else {
                // تحويل الرد إلى مصفوفة جسون
                $data = json_decode($response, true);

                // عرض الاستجابة في جدول HTML
                echo "<table border='1'>";
                echo "<tr>
                        <th>rfidScanDataId</th>
                        <th>epc</th>
                        <th>tagNumber</th>
                        <th>assetBarcode</th>
                        <th>operator</th>
                        <th>assetType</th>
                        <th>readTimestamp</th>
                        <th>region</th>
                        <th>city</th>
                        <th>locationSpecifier</th>
                        <th>locationTag1</th>
                        <th>locationTag2</th>
                        <th>latitude</th>
                        <th>longitude</th>
                        <th>operation</th>
                        <th>scanState</th>
                      </tr>";

                foreach ($data as $row) {
                    echo "<tr>
                            <td>{$row['rfidScanDataId']}</td>
                            <td>{$row['epc']}</td>
                            <td>{$row['tagNumber']}</td>
                            <td>{$row['assetBarcode']}</td>
                            <td>{$row['operator']}</td>
                            <td>{$row['assetType']}</td>
                            <td>{$row['readTimestamp']}</td>
                            <td>{$row['region']}</td>
                            <td>{$row['city']}</td>
                            <td>{$row['locationSpecifier']}</td>
                            <td>{$row['locationTag1']}</td>
                            <td>{$row['locationTag2']}</td>
                            <td>{$row['latitude']}</td>
                            <td>{$row['longitude']}</td>
                            <td>{$row['operation']}</td>
                            <td>{$row['scanState']}</td>
                          </tr>";
                }
                echo "</table>";
            }
        } else {
            echo "خطأ في الحصول على الرمز المميز: " . $response;
        }
    }
} else {
    // عرض نموذج HTML لإدخال التواريخ
    echo '<form method="post">
            <label for="startTime">تاريخ البداية:</label>
            <input type="datetime-local" id="startTime" name="startTime" required><br><br>
            <label for="endTime">تاريخ النهاية:</label>
            <input type="datetime-local" id="endTime" name="endTime" required><br><br>
            <input type="submit" value="إرسال">
          </form>';
}
?>
